import { Component, OnInit } from '@angular/core';
import { ActiveState } from '../../core/activestate/activestate.service'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { Product } from '../../core/maincontent/product'

@Component({
  selector: 'app-eadmin-home',
  templateUrl: './eadmin-home.component.html',
  styleUrls: ['./eadmin-home.component.css']
})
export class EadminHomeComponent implements OnInit {
  maincontentService: MainContentService
  product: Product

  constructor(public activeState: ActiveState,
          private mcService: MainContentService) {
    this.maincontentService = mcService
  }

  ngOnInit() {
    this.maincontentService.getProduct('eadmin').subscribe(this.contentUpdate.bind(this))
  }

  contentUpdate(prod: Product) {
    this.product = prod
  }

}
